/* Render customizado para exibir data no pattern desejado
 * O formato do pattern deve está de acordo com a biblioteca moment.js (http://momentjs.com/)
 * Autor: Gilvan Filho
 *  
 * Exemplo de uso:
 * 
 * function montarTabela($dados) {

        $scope.tabela = {};
        let cols = [
            'id', 
            {data: 'dataRecebimento', render: customDateRender },
            'status'
        ];
        let options = {enableSelection: false, order: [3, 'asc'], };
        $scope.tabela = $component.createResponsiveTable('#tabela', cols, $dados, options);
        $scope.tabela.render();
	}
 *	
 * */

function customMoneyRenderer(valor) {
    return valor.toLocaleString("pt-BR", {style: "currency", currency: "BRL"});
}

function customDateRender(data, type, row) {
    if (data == null)
        return null;
    return moment(data).format('DD/MM/YYYY');
}

function customDateTimeRender(data, type, row) {
    if (data == null)
        return null;
    return moment(data).format('DD/MM/YYYY HH:mm:ss');
}


$(document).ready(function () {
    $(".mask-cnpj").mask("99.999.999/9999-99");

    $(".mascara_conta").mask("999.999-9");

    $('input,select,textarea').focus(function () {
        $(this).parents('.form-group').addClass('focused');
    });
    // $('input,select,textarea').hover(function () {
    //     $(this).parents('.form-group').addClass('focused');
    // }, function(){
    //     $(this).parents('.form-group').removeClass('focused');
    // });


    $("select,input,textarea").each(function () {
        if ($.trim($(this).val()).length > 0) {
            $(this).parents('.form-group').addClass('filled');
            $(this).addClass('filled');
        }
    });

    $('input,select,textarea').blur(function () {
        var inputValue = $(this).val();
        if (inputValue == "") {
            $(this).removeClass('filled');
            $(this).parents('.form-group').removeClass('focused');
        } else {
            $(this).addClass('filled');
        }
    })

    $('.custom-file-input').on('change', function () {
        var fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').addClass("selected").html(fileName);
    });


});
ko.bindingHandlers.masked = {
    init: function(element, valueAccessor, allBindingsAccessor) {
        var mask = allBindingsAccessor().mask || {};
        $(element).inputmask(mask);
        $element =$(element)
        $element.val(ko.unwrap(valueAccessor()));
        let updateValueEvent = event => {
            var value = valueAccessor();
            if (ko.isObservable(value)) {
                value($element.val());
            }
        }
        $element.on('change', updateValueEvent);
        $element.enterKeyEvent(updateValueEvent);
    },
    update: function (element, valueAccessor) {
        var value = valueAccessor();
        var finalValue = utils.removeSpecialCharacters(ko.unwrap(value));
        var  $element = $(element);
        value(finalValue);
        $element.inputmask('setvalue', finalValue ? finalValue : 'null');
    }
};

function contaRender(data, type, row) {
    if (data == null)
        return null;
    return $("<div>"+data.padStart(7,"0")+"</div>").inputmask('999.999-9').val();
}