/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancoamazonia.sipaeweb.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ValidaCpfCnpj {
    public static boolean isCPF(String CPF2) {
        if (CPF2.equals("00000000000") || CPF2.equals("11111111111") || CPF2.equals("22222222222") || CPF2.equals("33333333333") || CPF2.equals("44444444444") || CPF2.equals("55555555555") || CPF2.equals("66666666666") || CPF2.equals("77777777777") || CPF2.equals("88888888888") || CPF2.equals("99999999999") || CPF2.length() != 11) {
            return false;
        }
        try {
            int i;
            int sm = 0;
            int peso = 10;
            for (i = 0; i < 9; ++i) {
                int num = CPF2.charAt(i) - 48;
                sm += num * peso;
                --peso;
            }
            int r = 11 - sm % 11;
            char dig10 = r == 10 || r == 11 ? (char)'0' : (char)((char)(r + 48));
            sm = 0;
            peso = 11;
            for (i = 0; i < 10; ++i) {
                int num = CPF2.charAt(i) - 48;
                sm += num * peso;
                --peso;
            }
            r = 11 - sm % 11;
            char dig11 = r == 10 || r == 11 ? (char)'0' : (char)((char)(r + 48));
            return dig10 == CPF2.charAt(9) && dig11 == CPF2.charAt(10);
        }
        catch (InputMismatchException erro) {
            return false;
        }
    }

    public static String imprimeCPF(String CPF2) {
        return CPF2.substring(0, 3) + "." + CPF2.substring(3, 6) + "." + CPF2.substring(6, 9) + "-" + CPF2.substring(9, 11);
    }

    public static boolean isCNPJ(String CNPJ) {
        if (CNPJ.equals("00000000000000") || CNPJ.equals("11111111111111") || CNPJ.equals("22222222222222") || CNPJ.equals("33333333333333") || CNPJ.equals("44444444444444") || CNPJ.equals("55555555555555") || CNPJ.equals("66666666666666") || CNPJ.equals("77777777777777") || CNPJ.equals("88888888888888") || CNPJ.equals("99999999999999") || CNPJ.length() != 14) {
            return false;
        }
        try {
            int i;
            int sm = 0;
            int peso = 2;
            for (i = 11; i >= 0; --i) {
                int num = CNPJ.charAt(i) - 48;
                sm += num * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            int r = sm % 11;
            char dig13 = r == 0 || r == 1 ? (char)'0' : (char)((char)(11 - r + 48));
            sm = 0;
            peso = 2;
            for (i = 12; i >= 0; --i) {
                int num = CNPJ.charAt(i) - 48;
                sm += num * peso;
                if (++peso != 10) continue;
                peso = 2;
            }
            r = sm % 11;
            char dig14 = r == 0 || r == 1 ? (char)'0' : (char)((char)(11 - r + 48));
            return dig13 == CNPJ.charAt(12) && dig14 == CNPJ.charAt(13);
        }
        catch (InputMismatchException erro) {
            return false;
        }
    }

    public static String imprimeCNPJ(String CNPJ) {
        return CNPJ.substring(0, 2) + "." + CNPJ.substring(2, 5) + "." + CNPJ.substring(5, 8) + "." + CNPJ.substring(8, 12) + "-" + CNPJ.substring(12, 14);
    }

    public static int modulo11(String numero) {
        int count = 0;
        int multi = 1;
        int limite = numero.length();
        List listaInt = Arrays.stream(numero.chars().map(c -> c - 48).toArray()).boxed().collect(Collectors.toList());
        Collections.reverse(listaInt);
        Iterator iterator = listaInt.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            count += n * ++multi;
            if (multi != limite) continue;
            multi = 1;
        }
        return count * 10 % 11;
    }
}

