/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancoamazonia.sipaeweb.manager;

import br.com.bancoamazonia.sipaeweb.domain.model.entity.EmpregadoEntity;
import br.com.bancoamazonia.sipaeweb.domain.repository.EmpregadoRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EmpregadoManager {
    @Autowired
    private EmpregadoRepository repository;

    public Iterable<EmpregadoEntity> listarEmpregados() {
        return this.repository.findAll();
    }

    public List<EmpregadoEntity> listarEmpregadosPorEmpresa(Long empresaId) {
        return this.repository.getEmpregadoByEmpresa(empresaId);
    }

    public EmpregadoEntity salvar(EmpregadoEntity empregadoEntity) {
        return (EmpregadoEntity)this.repository.save((Object)empregadoEntity);
    }

    public Optional<EmpregadoEntity> getById(Long id) {
        return this.repository.findById((Object)id);
    }

    public Optional<EmpregadoEntity> getByEmpresaCpf(Long empresaId, String cpf) {
        return this.repository.getEmpregadoEmpresa(empresaId, cpf);
    }

    public void excluir(Long empregadoId) {
        this.repository.deleteById((Object)empregadoId);
    }
}

