/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancoamazonia.sipaeweb.manager;

import br.com.bancoamazonia.sipaeweb.domain.model.dto.GerarArquivoDTO;
import br.com.bancoamazonia.sipaeweb.domain.model.entity.ArquivoEntity;
import br.com.bancoamazonia.sipaeweb.domain.model.entity.EmpresaEntity;
import br.com.bancoamazonia.sipaeweb.domain.repository.ArquivoRepository;
import br.com.bancoamazonia.sipaeweb.domain.repository.EmpregadoRepository;
import br.com.bancoamazonia.sipaeweb.domain.repository.EmpresaRepository;
import br.com.bancoamazonia.sipaeweb.util.ValidaCpfCnpj;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ArquivoManager {
    private ArquivoRepository arquivoRepository;
    private EmpregadoRepository empregadoRepository;
    private EmpresaRepository empresaRepository;
    private List<String> errors = new ArrayList();
    private String msg = "";
    private String arquivoDownloadNome = "";

    @Autowired
    public ArquivoManager(ArquivoRepository arquivoRepository, EmpregadoRepository empregadoRepository, EmpresaRepository empresaRepository) {
        this.arquivoRepository = arquivoRepository;
        this.empregadoRepository = empregadoRepository;
        this.empresaRepository = empresaRepository;
    }

    public byte[] downloadArquivo(Long arquivoId) {
        Optional arquivo = this.arquivoRepository.getArquivoGerado(arquivoId);
        if (!arquivo.isPresent()) {
            this.errors.add("Arquivo nencontrado");
            return null;
        }
        ArquivoEntity a = (ArquivoEntity)arquivo.get();
        this.setArquivoDownloadNome(a.getNome());
        Path path = Paths.get("arquivos" + File.pathSeparator + a.getNome(), new String[0]);
        byte[] arquivoDisco = null;
        try {
            arquivoDisco = Files.readAllBytes(path);
        }
        catch (IOException e) {
            this.errors.add("Nfoi posscarregar o arquivo: " + e.getMessage());
        }
        return arquivoDisco;
    }

    public File downloadArquivo2(Long arquivoId) {
        Optional arquivo = this.arquivoRepository.getArquivoGerado(arquivoId);
        if (!arquivo.isPresent()) {
            this.errors.add("Arquivo nencontrado");
            return null;
        }
        ArquivoEntity a = (ArquivoEntity)arquivo.get();
        return new File("arquivos/" + a.getNome());
    }

    public boolean gerarArquivoCNAB(GerarArquivoDTO params) throws IOException {
        File tmp;
        Optional empresa = this.empresaRepository.getEmpresaPorConvenio(Integer.valueOf(params.getCodConvenio()));
        if (!empresa.isPresent()) {
            this.errors.add("Convenio necontrado!");
            return false;
        }
        List empregados = this.empregadoRepository.getEmpregadoArquivo(Integer.valueOf(params.getCodConvenio()));
        if (empregados.size() == 0) {
            this.errors.add("Nenhum empregado com salmaior que zero encontrado");
            return false;
        }
        Date data = new Date();
        String formato = "ddMMyyyy";
        SimpleDateFormat formatter = new SimpleDateFormat(formato);
        String dataFormatada = formatter.format(data);
        if (data.compareTo(params.getDataCredito()) > 0) {
            this.errors.add("A Data informada deve ser maior que hoje");
            return false;
        }
        String dataArquivo = new SimpleDateFormat("ddMM").format(params.getDataCredito());
        SimpleDateFormat format = new SimpleDateFormat("HHmmss");
        String horaFormatada = format.format(data);
        DecimalFormat df = new DecimalFormat("#.00");
        ArquivoEntity arquivoEntity = new ArquivoEntity();
        arquivoEntity.setConvenio(((EmpresaEntity)empresa.get()).getCodConvenio());
        arquivoEntity.setNome(" ");
        arquivoEntity.setQntEmpregados(Integer.valueOf(empregados.size()));
        Double vlrTotalArquivo = empregados.stream().map(e -> e.getSalario()).reduce(0.0, (x, y) -> x + y);
        arquivoEntity.setValorTotal(vlrTotalArquivo);
        arquivoEntity.setDataCredito(params.getDataCredito());
        int seqArquivo = ((EmpresaEntity)empresa.get()).getSeqArquivo() + 1;
        ((EmpresaEntity)empresa.get()).setSeqArquivo(Integer.valueOf(seqArquivo));
        this.empresaRepository.save(empresa.get());
        arquivoEntity.setNome(String.format("%s%s.%s", this.lpad(String.valueOf(((EmpresaEntity)empresa.get()).getCodConvenio()), 4, "0"), dataArquivo, "1"));
        arquivoEntity = (ArquivoEntity)this.arquivoRepository.save((Object)arquivoEntity);
        ArrayList<String> linhas = new ArrayList<String>();
        StringBuffer header = new StringBuffer().append("003").append("0000").append("0").append(this.rpad(" ", 9)).append("2").append(this.lpad(((EmpresaEntity)empresa.get()).getCnpj().replaceAll("\\D", ""), 14, "0")).append(this.lpad(String.valueOf(((EmpresaEntity)empresa.get()).getCodConvenio()), 4, "0") + this.rpad("", 16, " ")).append(this.lpad(String.valueOf(((EmpresaEntity)empresa.get()).getAgencia().getCodAg()), 5, "0")).append(this.lpad(String.valueOf(ValidaCpfCnpj.modulo11((String)((EmpresaEntity)empresa.get()).getAgencia().getCodAg())), 1, "0")).append(this.lpad(((EmpresaEntity)empresa.get()).getContaCorrente().replaceAll("\\D+", ""), 13, "0")).append(" ").append(this.rpad(((EmpresaEntity)empresa.get()).getNome(), 30, " ")).append(this.rpad("BANCO DA AMAZONIA SA", 30, " ")).append(this.rpad(" ", 10)).append("1").append(dataFormatada).append(horaFormatada).append(this.lpad(String.valueOf(seqArquivo), 6, "0")).append("030").append("00000").append(this.rpad(" ", 20, " ")).append(this.rpad(" ", 20, " ")).append(this.rpad(" ", 14, " ")).append("000").append(this.rpad(" ", 12, " "));
        linhas.add(header.toString());
        StringBuffer headerLote = new StringBuffer().append("003").append("0001").append("1").append("C").append("30").append("01").append("020").append(this.rpad(" ", 1)).append("2").append(this.lpad(((EmpresaEntity)empresa.get()).getCnpj().replaceAll("\\D", ""), 14, "0")).append(this.lpad(String.valueOf(((EmpresaEntity)empresa.get()).getCodConvenio()), 4, "0") + this.rpad("", 16, " ")).append(this.lpad(String.valueOf(((EmpresaEntity)empresa.get()).getAgencia().getCodAg()), 5, "0")).append(this.lpad(String.valueOf(ValidaCpfCnpj.modulo11((String)((EmpresaEntity)empresa.get()).getAgencia().getCodAg())), 1, "0")).append(this.lpad(((EmpresaEntity)empresa.get()).getContaCorrente().replaceAll("\\D", ""), 13, "0")).append(this.rpad(" ", 1)).append(this.rpad(((EmpresaEntity)empresa.get()).getNome(), 30, " ")).append(this.rpad(" ", 40)).append(this.rpad(" ", 30)).append("00000").append(this.rpad(" ", 15)).append(this.rpad(" ", 20)).append("00000000").append(this.rpad(" ", 2)).append(this.rpad(" ", 18));
        linhas.add(headerLote.toString());
        int[] contador = new int[]{4};
        empregados.stream().map(empregado -> {
            contador[0] = contador[0] + 1;
            return new StringBuffer().append("003").append("0001").append("3").append(this.lpad(String.valueOf(contador[0]), 5, "0")).append("A").append("0").append("00").append("000").append("003").append(this.lpad(String.valueOf(empregado.getAgencia().getCodAg()), 5, "0")).append(this.lpad(String.valueOf(ValidaCpfCnpj.modulo11((String)empregado.getAgencia().getCodAg())), 1, "0")).append(this.lpad(empregado.getContaCorrente().replaceAll("\\D", ""), 13, "0")).append(this.rpad(" ", 1)).append(this.rpad(empregado.getNome().toUpperCase(), 30, " ")).append(this.lpad(String.valueOf(empregado.getId()), 20, "0")).append(formatter.format(params.dataCredito)).append("BRL").append(this.lpad("", 15, "0")).append(this.lpad(df.format(empregado.getSalario()).replaceAll("\\D", ""), 15, "0")).append(this.rpad(" ", 20)).append(this.rpad(formatter.format(params.dataCredito), 8)).append(this.rpad(df.format(empregado.getSalario()).replaceAll("\\D", ""), 15, "0")).append(this.rpad(" ", 40)).append(this.rpad(" ", 12)).append(" ").append(this.rpad("00", 2)).append(this.rpad(" ", 8));
        }).map(StringBuffer::toString).forEach(linhas::add);
        StringBuffer trailerInventario = new StringBuffer().append("003").append("0001").append("5").append(this.rpad(" ", 9)).append(this.lpad(String.valueOf(empregados.size()), 6, "0")).append(this.lpad(String.valueOf(vlrTotalArquivo).replaceAll("\\D", ""), 18, "0")).append(this.rpad("0", 18)).append(this.rpad(" ", 181));
        linhas.add(trailerInventario.toString());
        StringBuffer trailerArquivo = new StringBuffer().append("003").append("9999").append("9").append(this.rpad(" ", 9)).append("000001").append(this.lpad(String.valueOf(contador[0]), 6, "0")).append("000000").append(this.rpad(" ", 205));
        linhas.add(trailerArquivo.toString());
        String arquivo = String.join((CharSequence)"\r\n", linhas);
        File dir = new File("arquivos");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((tmp = new File(dir, arquivoEntity.getNome())).exists()) {
            for (int i = 2; i < 200; ++i) {
                arquivoEntity.setNome(String.format("%s%s.%s", this.lpad(String.valueOf(((EmpresaEntity)empresa.get()).getCodConvenio()), 4, "0"), dataArquivo, String.valueOf(i)));
                tmp = new File(dir, arquivoEntity.getNome());
                if (!tmp.exists()) break;
            }
            arquivoEntity = (ArquivoEntity)this.arquivoRepository.save((Object)arquivoEntity);
        }
        tmp.createNewFile();
        tmp.setWritable(true);
        BufferedWriter writer = new BufferedWriter(new FileWriter(tmp));
        writer.write(arquivo);
        writer.flush();
        writer.close();
        ObjectMapper mapper = new ObjectMapper();
        String salvarEmpregados = mapper.writeValueAsString((Object)empregados);
        arquivoEntity.setDetalhesJson(salvarEmpregados);
        arquivoEntity.setStatus("G");
        this.arquivoRepository.save((Object)arquivoEntity);
        return true;
    }

    public Iterable<ArquivoEntity> listarArquivos() {
        return this.arquivoRepository.findAll();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String getArquivoDownloadNome() {
        return this.arquivoDownloadNome;
    }

    public void setArquivoDownloadNome(String arquivoDownloadNome) {
        this.arquivoDownloadNome = arquivoDownloadNome;
    }

    private String lpad(String str, int tamanho, String padStr) {
        if (str.length() > tamanho) {
            return str.substring(0, tamanho);
        }
        return StringUtils.leftPad((String)str, (int)tamanho, (String)padStr);
    }

    private String lpad(String str, int tamanho) {
        return this.lpad(str, tamanho, " ");
    }

    private String rpad(String str, int tamanho, String padStr) {
        if (str.length() > tamanho) {
            return str.substring(0, tamanho);
        }
        return StringUtils.rightPad((String)str, (int)tamanho, (String)padStr);
    }

    private String rpad(String str, int tamanho) {
        return this.rpad(str, tamanho, " ");
    }
}

