/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancoamazonia.sipaeweb.domain.model.entity;

import br.com.amazoniafw.base.components.model.EntityModel;
import br.com.bancoamazonia.sipaeweb.domain.model.entity.AgenciaEntity;
import java.text.ParseException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.swing.text.MaskFormatter;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonProperty;

@Entity
@Table(name="EMPRESAS")
@SequenceGenerator(name="SEQ_EMPRESA", sequenceName="SEQ_EMPRESAS", initialValue=1, allocationSize=1)
public class EmpresaEntity
implements EntityModel<Long> {
    private static final long serialVersionUID = -4441833679228614860L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SEQ_EMPRESA")
    @Column(name="ID")
    private Long id;
    @NotNull
    @Column(name="COD_CONVENIO", unique=true)
    private Integer codConvenio;
    @NotNull
    @Column(name="NOME")
    private String nome;
    @ManyToOne
    @NotNull
    @JoinColumn(name="AGENCIA_ID")
    private AgenciaEntity agencia;
    @Column(name="POSTO")
    private Integer posto;
    @NotNull
    @Column(name="CONTA_CORRENTE", unique=true)
    private String contaCorrente;
    @NotNull
    @Column(name="CNPJ", unique=true)
    private String cnpj;
    @NotNull
    @Column(name="ATIVO", columnDefinition=" BOOLEAN DEFAULT true")
    private boolean ativo = true;
    @NotNull
    @Column(name="SEQ_ARQUIVO")
    private Integer seqArquivo = 0;

    public EmpresaEntity(@NotNull Integer codConvenio, @NotNull String nome, String agencia, Integer posto, @NotNull String contaCorrente, @NotNull String cnpj, boolean ativo) {
        this.codConvenio = codConvenio;
        this.nome = nome;
        this.agencia = new AgenciaEntity();
        this.agencia.setId(Long.valueOf(Long.parseLong(agencia)));
        this.posto = posto;
        this.contaCorrente = contaCorrente;
        this.cnpj = cnpj;
        this.ativo = true;
    }

    public EmpresaEntity() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getCodConvenio() {
        return this.codConvenio;
    }

    public void setCodConvenio(Integer codConvenio) {
        this.codConvenio = codConvenio;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public AgenciaEntity getAgencia() {
        return this.agencia;
    }

    public void setAgencia(AgenciaEntity agencia) {
        this.agencia = agencia;
    }

    public void setAgencia(String agencia) {
        this.agencia = new AgenciaEntity();
        this.agencia.setId(Long.valueOf(Long.parseLong(agencia)));
    }

    public Integer getPosto() {
        return this.posto;
    }

    public void setPosto(Integer posto) {
        this.posto = posto;
    }

    public String getContaCorrente() {
        return this.contaCorrente;
    }

    public void setContaCorrente(String numConta) {
        this.contaCorrente = numConta;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    @JsonProperty(value="cnpj_formatado")
    public String getCnpjFormatado() {
        String cnpj = StringUtils.leftPad((String)this.cnpj, (int)14, (String)"0");
        try {
            MaskFormatter mask = new MaskFormatter("##.###.###/####-##");
            mask.setValueContainsLiteralCharacters(false);
            return mask.valueToString(cnpj);
        }
        catch (ParseException ex) {
            return ex.getMessage();
        }
    }

    @JsonProperty(value="empresaConvenioDisplay")
    public String getEmpresaConvenioDisplay() {
        return this.getCodConvenio() + " - " + this.getNome();
    }

    public void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public boolean isAtivo() {
        return this.ativo;
    }

    public void setAtivo(boolean ativo) {
        this.ativo = ativo;
    }

    @JsonProperty(value="agencia_id")
    public Long getAgenciaId() {
        return this.agencia == null ? null : this.agencia.getId();
    }

    @JsonProperty(value="agencia_nome")
    public String getAgenciaNome() {
        return this.agencia == null ? null : this.agencia.getNome();
    }

    @JsonProperty(value="agencia_display")
    public String getAgenciaDisplay() {
        return this.agencia == null ? null : String.format("%03d", this.agencia.getId()) + " - " + this.agencia.getNome();
    }

    @JsonProperty(value="agencia_display")
    public Integer getSeqArquivo() {
        return this.seqArquivo;
    }

    public void setSeqArquivo(Integer seqArquivo) {
        this.seqArquivo = seqArquivo;
    }
}

