/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancoamazonia.sipaeweb.domain.model.entity;

import br.com.amazoniafw.base.components.model.EntityModel;
import br.com.bancoamazonia.sipaeweb.domain.enums.EstadoEnum;
import br.com.bancoamazonia.sipaeweb.domain.model.entity.AgenciaEntity;
import br.com.bancoamazonia.sipaeweb.domain.model.entity.EmpresaEntity;
import java.text.ParseException;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.swing.text.MaskFormatter;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonProperty;
import org.hibernate.validator.constraints.br.CPF;

@Entity
@Table(name="EMPREGADOS", uniqueConstraints={@UniqueConstraint(columnNames={"EMPRESA_ID", "CPF", "CONTA_CORRENTE"})})
@SequenceGenerator(name="SEQ_EMPREGADO", sequenceName="SEQ_EMPREGADOS", initialValue=1, allocationSize=1)
public class EmpregadoEntity
implements EntityModel<Long> {
    private static final long serialVersionUID = 6196728239447837463L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SEQ_EMPREGADO")
    private Long id;
    @ManyToOne
    @JoinColumn(name="EMPRESA_ID")
    private EmpresaEntity empresa;
    @NotNull
    @Column(name="NOME")
    private String nome;
    @ManyToOne
    @JoinColumn(name="AGENCIA_ID")
    private AgenciaEntity agencia;
    @Column(name="POSTO")
    private Integer posto;
    @NotNull
    @Column(name="CONTA_CORRENTE")
    private String contaCorrente;
    @NotNull
    @Digits(integer=13, fraction=2, message="Valor maior que o permitido.")
    @Column(name="SALARIO")
    private @NotNull @Digits(integer=13, fraction=2, message="Valor maior que o permitido.") double salario;
    @Column(name="TIPO_CONTA")
    private String tipoConta;
    @Column(name="ENDERECO")
    private String endereco;
    @Column(name="NUMERO")
    private Integer numero;
    @Column(name="COMPLEMENTO")
    private String complemento;
    @Column(name="BAIRRO")
    private String bairro;
    @Column(name="CEP")
    private String cep;
    @Column(name="CIDADE")
    private String cidade;
    @Enumerated(value=EnumType.STRING)
    @Column(name="ESTADO")
    private EstadoEnum estado;
    @CPF
    @Column(name="CPF")
    private String cpf;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public EmpresaEntity getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(EmpresaEntity empresa) {
        this.empresa = empresa;
    }

    public AgenciaEntity getAgencia() {
        return this.agencia;
    }

    public void setAgencia(AgenciaEntity agencia) {
        this.agencia = agencia;
    }

    public Integer getPosto() {
        return this.posto;
    }

    public void setPosto(Integer posto) {
        this.posto = posto;
    }

    public String getContaCorrente() {
        return StringUtils.leftPad((String)this.contaCorrente, (int)7, (String)"0");
    }

    public void setContaCorrente(String contaCorrente) {
        this.contaCorrente = StringUtils.leftPad((String)contaCorrente.replaceAll("\\D", ""), (int)7, (String)"0");
    }

    public double getSalario() {
        return this.salario;
    }

    public void setSalario(double salario) {
        this.salario = salario;
    }

    public String getEndereco() {
        return this.endereco;
    }

    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    public Integer getNumero() {
        return this.numero;
    }

    public void setNumero(Integer numero) {
        this.numero = numero;
    }

    public String getComplemento() {
        return this.complemento;
    }

    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    public String getBairro() {
        return this.bairro;
    }

    public void setBairro(String bairro) {
        this.bairro = bairro;
    }

    public String getCep() {
        return this.cep;
    }

    public void setCep(String cep) {
        this.cep = cep;
    }

    public String getCidade() {
        return this.cidade;
    }

    public void setCidade(String cidade) {
        this.cidade = cidade;
    }

    public EstadoEnum getEstado() {
        return this.estado;
    }

    public void setEstado(EstadoEnum estado) {
        this.estado = estado;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    @JsonProperty(value="agencia_display")
    public String getAgenciaDisplay() {
        if (this.agencia != null) {
            return this.agencia.getCodAg() + " - " + this.agencia.getDescricao();
        }
        return "";
    }

    @JsonProperty(value="empresa_convenio")
    public String getEmpresaDisplay() {
        if (this.empresa != null) {
            return this.empresa.getEmpresaConvenioDisplay();
        }
        return "";
    }

    @JsonProperty(value="cpf_formatado")
    public String getCpfFormatado() {
        String cnpj = StringUtils.leftPad((String)this.cpf, (int)11, (String)"0");
        try {
            MaskFormatter mask = new MaskFormatter("###.###.###-##");
            mask.setValueContainsLiteralCharacters(false);
            return mask.valueToString(cnpj);
        }
        catch (ParseException ex) {
            return ex.getMessage();
        }
    }

    @JsonProperty(value="agencia")
    public Long getAgenciaId() {
        if (this.agencia != null) {
            return this.agencia.getId();
        }
        return 0L;
    }

    @JsonProperty(value="empresa")
    public Long getEmpresaId() {
        if (this.empresa != null) {
            return this.empresa.getId();
        }
        return 0L;
    }
}

