/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancoamazonia.sipaeweb.controller;

import br.com.amazoniafw.base.exceptions.displayable.WorkflowException;
import br.com.bancoamazonia.sbs.servlet.web.responsehandlers.ActionResponse;
import br.com.bancoamazonia.sbs.servlet.web.responsehandlers.controller.ControllerResponse;
import br.com.bancoamazonia.sipaeweb.controller.BasaAbstractController;
import br.com.bancoamazonia.sipaeweb.domain.model.entity.EmpresaEntity;
import br.com.bancoamazonia.sipaeweb.domain.repository.AgenciaRepository;
import br.com.bancoamazonia.sipaeweb.domain.repository.EmpresaRepository;
import br.com.bancoamazonia.sipaeweb.manager.EmpresaManager;
import br.com.bancoamazonia.sipaeweb.util.ValidaCpfCnpj;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"convenio"})
public class EmpresaController
extends BasaAbstractController {
    @Autowired
    EmpresaManager empresaManager;
    @Autowired
    EmpresaRepository empresaRepository;
    @Autowired
    AgenciaRepository agenciaRepository;
    @Autowired
    ControllerResponse response;
    String successMsg = "";

    @GetMapping(value={"/"})
    public ActionResponse index() {
        return this.response.view("empresa-lista");
    }

    @GetMapping(value={"/lista_empresas"})
    public ActionResponse listaEmpresas() {
        List listEmpresas = (List)this.empresaManager.listarEmpresas();
        return ((ControllerResponse)this.response.viewdata("empresas", (Object)listEmpresas)).sendNow();
    }

    @GetMapping(value={"/novo"})
    public ActionResponse novo() {
        List agencias = (List)this.agenciaRepository.findAll();
        return ((ControllerResponse)this.response.viewdata("agencias", (Object)agencias)).view("empresa-form");
    }

    @GetMapping(value={"/{id}"})
    public ActionResponse editar(@PathVariable Long id) {
        Optional empresa = this.empresaManager.getById(id);
        if (empresa.isPresent()) {
            List agencias = (List)this.agenciaRepository.findAll();
            return ((ControllerResponse)((ControllerResponse)this.response.viewdata("agencias", (Object)agencias)).viewdata("empresa", (Object)empresa)).view("empresa-form");
        }
        throw new WorkflowException("Nfoi encontrada a empresa solicitada");
    }

    @PostMapping(value={"/salvar"})
    public ActionResponse salvar(EmpresaEntity empresa) {
        try {
            if (!ValidaCpfCnpj.isCNPJ((String)empresa.getCnpj())) {
                return ((ControllerResponse)this.response.danger("CNPJ Inv\u00e1lido")).redirectTo("/convenio/novo/");
            }
            if (empresa.getSeqArquivo() == null) {
                empresa.setSeqArquivo(Integer.valueOf(0));
            }
            EmpresaEntity emp = this.empresaManager.salvar(empresa);
            this.successMsg = "Empresa " + emp.getNome() + " salva com sucesso";
            return ((ControllerResponse)this.response.danger(this.successMsg)).redirectTo("/convenio/");
        }
        catch (DataIntegrityViolationException dv) {
            return ((ControllerResponse)this.response.danger(dv.getMessage())).redirectTo("/convenio/novo/");
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResponse excluir(@PathVariable Long id) {
        try {
            this.empresaRepository.deleteById((Object)id);
            return ((ControllerResponse)this.response.success("Exclucom sucesso!")).sendNow();
        }
        catch (DataIntegrityViolationException ex) {
            ex.printStackTrace();
            return ((ControllerResponse)this.response.warn("Violade integridade de dados. Vocprovavelmente tentou excluir um registro em uso por outras entidades do sistema. A operafoi cancelada.")).sendNow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ((ControllerResponse)this.response.warn(ex.getMessage())).sendNow();
        }
    }
}

