/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancoamazonia.sipaeweb.controller;

import br.com.amazoniafw.base.exceptions.displayable.WorkflowException;
import br.com.bancoamazonia.sbs.servlet.web.responsehandlers.ActionResponse;
import br.com.bancoamazonia.sbs.servlet.web.responsehandlers.controller.ControllerResponse;
import br.com.bancoamazonia.sipaeweb.controller.BasaAbstractController;
import br.com.bancoamazonia.sipaeweb.domain.model.dto.EmpregadoImportacaoDTO;
import br.com.bancoamazonia.sipaeweb.domain.model.entity.AgenciaEntity;
import br.com.bancoamazonia.sipaeweb.domain.model.entity.EmpregadoEntity;
import br.com.bancoamazonia.sipaeweb.domain.model.entity.EmpresaEntity;
import br.com.bancoamazonia.sipaeweb.domain.repository.EmpresaRepository;
import br.com.bancoamazonia.sipaeweb.manager.AgenciaManager;
import br.com.bancoamazonia.sipaeweb.manager.EmpregadoManager;
import br.com.bancoamazonia.sipaeweb.manager.EmpresaManager;
import br.com.bancoamazonia.sipaeweb.util.ValidaCpfCnpj;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.apache.axis.encoding.Base64;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"empregado"})
public class EmpregadoController
extends BasaAbstractController {
    @Autowired
    EmpregadoManager empregadoManager;
    @Autowired
    EmpresaManager empresaManager;
    @Autowired
    AgenciaManager agenciaManager;
    @Autowired
    ControllerResponse response;
    @Autowired
    EmpresaRepository empresaRepository;
    @Autowired
    ResourceLoader resourceLoader;

    @GetMapping(value={"/"})
    public ActionResponse index(@RequestParam(required=false) Long empresaId) {
        List empresas = (List)this.empresaManager.listarEmpresas();
        if (empresaId == null) {
            empresaId = (Long)this.session.getAttribute("empresaId");
        }
        return ((ControllerResponse)((ControllerResponse)this.response.viewdata("empresa_id", (Object)empresaId)).viewdata("empresas", (Object)empresas)).view("empregado-lista");
    }

    @GetMapping(value={"/lista_empregados/{empresaId}"})
    public ActionResponse lista_empregados(@PathVariable Long empresaId) {
        if (empresaId == null) {
            empresaId = (Long)this.session.getAttribute("empresaId");
        } else {
            this.session.setAttribute("empresaId", (Object)empresaId);
        }
        List listEmpregado = this.empregadoManager.listarEmpregadosPorEmpresa(empresaId);
        return ((ControllerResponse)this.response.viewdata("empregados", (Object)listEmpregado)).sendNow();
    }

    @GetMapping(value={"/novo"})
    public ActionResponse novo() {
        List empresas = (List)this.empresaManager.listarEmpresas();
        List agencias = (List)this.agenciaManager.listarAgencias();
        return ((ControllerResponse)((ControllerResponse)this.response.viewdata("empresas", (Object)empresas)).viewdata("agencias", (Object)agencias)).view("empregado-form");
    }

    @GetMapping(value={"/{id}"})
    public ActionResponse editar(@PathVariable Long id) {
        Optional empregado = this.empregadoManager.getById(id);
        if (empregado.isPresent()) {
            this.session.setAttribute("empregadoEdit", (Object)((EmpregadoEntity)empregado.get()).getId());
            List empresas = (List)this.empresaManager.listarEmpresas();
            List agencias = (List)this.agenciaManager.listarAgencias();
            return ((ControllerResponse)((ControllerResponse)((ControllerResponse)this.response.viewdata("empresas", (Object)empresas)).viewdata("agencias", (Object)agencias)).viewdata("empregado", (Object)empregado)).view("empregado-form");
        }
        throw new WorkflowException("Nfoi encontrada o registro selecionado");
    }

    @PostMapping(value={"/salvar"})
    public ActionResponse salvar(EmpregadoEntity empregado) {
        try {
            if (empregado.getId() != null) {
                Long empregadoId = (Long)this.session.getAttribute("empregadoEdit");
                if (!empregado.getId().equals(empregadoId)) {
                    return ((ControllerResponse)this.response.danger("Acesso inv\u00e1lido \u00e0 funcionalidade. Recarregue a p\u00e1gina")).sendNow();
                }
            }
            if (!ValidaCpfCnpj.isCPF((String)empregado.getCpf())) {
                return ((ControllerResponse)this.response.danger("CPF Inv\u00e1lido")).sendNow();
            }
            EmpregadoEntity emp = this.empregadoManager.salvar(empregado);
            return ((ControllerResponse)this.response.success("Empregado " + emp.getNome() + " salvo com sucesso")).redirectTo("/empregado/");
        }
        catch (DataIntegrityViolationException dv) {
            return ((ControllerResponse)this.response.danger("RelaEmpresa/Empresado/Conta jexiste! Operacancelada")).sendNow();
        }
        catch (TransactionSystemException transactionSystemException) {
            return ((ControllerResponse)this.response.danger("Verifique os dados e tente novamente")).sendNow();
        }
        catch (Exception e) {
            return ((ControllerResponse)this.response.danger("Ocorreu um erro interno no sistema")).sendNow();
        }
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResponse excluir(@PathVariable Long id) {
        try {
            this.empregadoManager.excluir(id);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ((ControllerResponse)this.response.success("Exclucom sucesso!")).sendNow();
    }

    @GetMapping(value={"/importar"})
    public ActionResponse formImportacao() {
        List empresas = (List)this.empresaManager.listarEmpresas();
        return ((ControllerResponse)this.response.viewdata("empresas", (Object)empresas)).view("empregado-importacao");
    }

    @PostMapping(value={"/importar"})
    public ActionResponse importarUsuariosCsv(EmpregadoImportacaoDTO empregado) {
        String headerEsperado;
        String[] linhas = this.arquivoLinhas(empregado);
        if (linhas.length <= 1) {
            return ((ControllerResponse)this.response.warn("O arquivo parece nconter nenhum registo.")).sendNow();
        }
        String header = linhas[0].replace("\r", "");
        if (!header.equalsIgnoreCase(headerEsperado = "CPF;NOME;AGENCIA;CONTA;POSTO;SALARIO")) {
            return ((ControllerResponse)this.response.warn("O arquivo npossui um cabevpara processamento")).sendNow();
        }
        StringBuilder log = new StringBuilder("Log de execu\n");
        log.append("Linha 1: Rdas colunas OK \n");
        IntStream.range(1, linhas.length).forEach(i -> {
            EmpregadoEntity e;
            String[] colunas = linhas[i].replace("\r", "").replace("\"", "").split(";", -1);
            Optional a = this.agenciaManager.findByCodAg(colunas[2].replaceAll("\\D+", ""));
            if (!a.isPresent()) {
                log.append("Linha " + (i + 1) + ": Agencia nlocalizada " + colunas[2] + "\n");
                return;
            }
            Optional empresa = this.empresaManager.getById(empregado.getEmpresaId());
            if (!empresa.isPresent()) {
                log.append("Linha " + (i + 1) + ": Empresa nlocalizada " + colunas[2] + "\n");
                return;
            }
            String cpf = StringUtils.leftPad((String)colunas[0].replaceAll("\\D+", ""), (int)11, (String)"0");
            Optional empregadoBanco = this.empregadoManager.getByEmpresaCpf(empregado.getEmpresaId(), cpf);
            if (empregadoBanco.isPresent()) {
                e = (EmpregadoEntity)empregadoBanco.get();
                log.append("Linha " + (i + 1) + ": Funcionjexistente. Atualizando os dados \n");
            } else {
                e = new EmpregadoEntity();
            }
            if (!ValidaCpfCnpj.isCPF((String)cpf)) {
                log.append("Linha " + (i + 1) + ":CPF Inv\n");
                return;
            }
            e.setCpf(cpf);
            e.setNome(colunas[1].toUpperCase());
            e.setAgencia((AgenciaEntity)a.get());
            e.setEmpresa((EmpresaEntity)empresa.get());
            e.setContaCorrente(colunas[3].replaceAll("\\D+", ""));
            if (!colunas[4].isEmpty()) {
                e.setPosto(Integer.valueOf(Integer.parseInt(colunas[4].replaceAll("\\D+", ""))));
            } else {
                e.setPosto(Integer.valueOf(0));
            }
            e.setSalario(Double.parseDouble(colunas[5].replace(".", "").replace(",", ".")));
            this.empregadoManager.salvar(e);
            log.append("Linha " + (i + 1) + ": Processado com sucesso!\n");
        });
        log.append("#### FIM DO PROCESSAMENTO ####\n");
        return ((ControllerResponse)this.response.viewdata("log", (Object)log)).sendNow();
    }

    @GetMapping(value={"/modelo"})
    public ResponseEntity<InputStreamResource> downloadModelo() throws IOException {
        InputStreamResource resource = new InputStreamResource(this.carregaModelo());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=modelo_importacao_sipae.csv"})).body((Object)resource);
    }

    public String[] arquivoLinhas(EmpregadoImportacaoDTO empregado) {
        String[] file = empregado.getArquivo().split(",");
        byte[] decoded = Base64.decode((String)file[1]);
        String arquivo = new String(decoded);
        String[] linhas = arquivo.replace("\r\n", "\n").split("\n");
        return linhas;
    }

    private InputStream carregaModelo() {
        return this.getClass().getResourceAsStream("/data/modelo_importacao_sipae.csv");
    }
}

