/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancoamazonia.sipaeweb.controller;

import br.com.bancoamazonia.sbs.servlet.web.responsehandlers.ActionResponse;
import br.com.bancoamazonia.sbs.servlet.web.responsehandlers.controller.ControllerResponse;
import br.com.bancoamazonia.sipaeweb.controller.BasaAbstractController;
import br.com.bancoamazonia.sipaeweb.domain.model.dto.GerarArquivoDTO;
import br.com.bancoamazonia.sipaeweb.manager.ArquivoManager;
import br.com.bancoamazonia.sipaeweb.manager.EmpresaManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"arquivo"})
public class ArquivoController
extends BasaAbstractController {
    @Autowired
    ControllerResponse response;
    @Autowired
    ArquivoManager arquivoManager;
    @Autowired
    EmpresaManager empresaManager;
    @Autowired
    private ServletContext servletContext;

    @GetMapping(value={"/"})
    public ActionResponse index() {
        List empresas = (List)this.empresaManager.listarEmpresas();
        return ((ControllerResponse)this.response.viewdata("empresas", (Object)empresas)).view("arquivo-lista");
    }

    @GetMapping(value={"/lista_arquivos"})
    public ActionResponse listaArquivos() {
        List listArquivos = (List)this.arquivoManager.listarArquivos();
        return ((ControllerResponse)this.response.viewdata("arquivos", (Object)listArquivos)).sendNow();
    }

    @PostMapping(value={"/"})
    public ActionResponse gerarArquivo(GerarArquivoDTO params) {
        try {
            if (this.arquivoManager.gerarArquivoCNAB(params)) {
                this.response.success("Arquivo gerado com sucesso!");
            } else {
                for (String error : this.arquivoManager.getErrors()) {
                    this.response.warn(error);
                }
                this.arquivoManager.setErrors(new ArrayList());
            }
        }
        catch (IOException e) {
            this.response.warn("Ocorreu um erro na criado arquivo: " + e.getMessage());
        }
        List listArquivos = (List)this.arquivoManager.listarArquivos();
        this.response.viewdata("arquivos", (Object)listArquivos);
        return this.response.sendNow();
    }

    @GetMapping(value={"/{arquivoId}"})
    public ResponseEntity<InputStreamResource> download_arquivo(@PathVariable Long arquivoId) {
        File file = this.arquivoManager.downloadArquivo2(arquivoId);
        InputStreamResource resource = null;
        try {
            resource = new InputStreamResource((InputStream)new FileInputStream(file));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment;filename=" + file.getName()})).contentLength(file.length()).body((Object)resource);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

