/*
 * Decompiled with CFR 0.152.
 */
package br.com.bancoamazonia.sipaeweb;

import br.com.amazoniafw.base.tools.datasource.DataSourceFactory;
import br.com.amazoniafw.base.tools.datasource.JpaResourcesFactory;
import br.com.amazoniafw.base.tools.datasource.config.AbstractConnectionInfo;
import br.com.bancoamazonia.sbs.commons.properties.AmzDatabaseProperties;
import br.com.bancoamazonia.sbs.commons.properties.AmzProjectProperties;
import br.com.bancoamazonia.sipaeweb.SipaeWebCsbanApplication;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement
@EnableAspectJAutoProxy(proxyTargetClass=true)
@EnableJpaRepositories(value={"br.com.bancoamazonia.sipaeweb.domain.repository"})
public class DatabaseConfiguration {
    private AmzProjectProperties projectProperties;
    private AbstractConnectionInfo connectionInfo;

    public DatabaseConfiguration(AmzDatabaseProperties properties, AmzProjectProperties projectProperties) {
        this.connectionInfo = properties.getConnectionInfoByName("h2local");
        this.projectProperties = projectProperties;
    }

    @Bean
    public DataSource dataSource() {
        return DataSourceFactory.createDataSource((AbstractConnectionInfo)this.connectionInfo);
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean entityManagerFactory(DataSource datasource) {
        return JpaResourcesFactory.createEntityManagerFactory(SipaeWebCsbanApplication.class, (AbstractConnectionInfo)this.connectionInfo, (DataSource)datasource, (boolean)true, (boolean)this.projectProperties.isDevelopment());
    }

    @Bean
    public PlatformTransactionManager transactionManager(EntityManagerFactory entityManagerFactory) {
        return JpaResourcesFactory.createTransactionManager((EntityManagerFactory)entityManagerFactory);
    }

    @Bean
    public void loadAgencias() throws SQLException {
        System.out.println("Carregando agencias");
        DataSource ds = this.dataSource();
        Connection conn = ds.getConnection();
        System.out.println(conn);
        PreparedStatement pst = conn.prepareStatement("\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('66','66', 'IGARAPMIRI', 'IGARAPMIRI');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('95','95', 'CARACARAI', 'CARACARAI');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('175','175', 'DOM ELISEU', 'DOM ELISEU');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('196','196', 'SANTANA DO ARAGUAIA', 'SANTANA DO ARAGUAIA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('186','186', 'ARAGUA\u00c7U', 'ARAGUA\u00c7U');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('178','178', 'EXTREMA', 'EXTREMA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('185','185', 'MARABA CIDADE NOVA', 'MARABA CIDADE NOVA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('174','174', 'XINGUARA', 'XINGUARA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('189','189', 'PIMENTA BUENO', 'PIMENTA BUENO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('193','193', 'S\u00c3O MIGUEL DO GUAPOR\u00c9', 'S\u00c3O MIGUEL DO GUAPOR\u00c9');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('192','192', 'MANACAPURU', 'MANACAPURU');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('97','97', 'TANGARDA SERRA', 'TANGARDA SERRA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('154','154', 'AVENIDA CEARA - RIO BRANCO', 'AVENIDA CEARA - RIO BRANCO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('176','176', 'TEFE', 'TEFE');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('78','78', 'TOM\u00c9 A\u00c7\u00da', 'TOM\u00c9 A\u00c7\u00da');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('81','81', 'S\u00c3O MIGUEL DO GUAM\u00c1', 'S\u00c3O MIGUEL DO GUAM\u00c1');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('88','88', 'ALTO PARNAIBA', 'ALTO PARNAIBA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('94','94', 'VILHENA', 'VILHENA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('103','103', 'ALENQUER', 'ALENQUER');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('106','106', 'BOCA DO ACRE', 'BOCA DO ACRE');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('130','130', 'PACAJ\u00c1', 'PACAJ\u00c1');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('131','131', 'MIRANORTE', 'MIRANORTE');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('136','136', 'XAPURI', 'XAPURI');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('146','146', 'REDENCAO', 'REDENCAO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('152','152', 'COLINA DO TOCANTINS', 'COLINA DO TOCANTINS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('153','153', 'ROLIM DE MOURA', 'ROLIM DE MOURA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('155','155', 'PARAISO DO TOCANTINS', 'PARAISO DO TOCANTINS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('156','156', 'URUARA', 'URUARA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('157','157', 'ESTREITO', 'ESTREITO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('158','158', 'ICOARACI', 'ICOARACI');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('6','6', 'BALSAS', 'BALSAS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('9','9', 'BOA VISTA', 'BOA VISTA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('12','12', 'BRASIL\u00c9IA', 'BRASIL\u00c9IA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('14','14', 'C\u00c1CERES', 'C\u00c1CERES');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('18','18', 'COARI', 'COARI');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('20','20', 'COROATA', 'COROATA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('21','21', 'CRUZEIRO DO SUL', 'CRUZEIRO DO SUL');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('22','22', 'CUIAB\u00c1', 'CUIAB\u00c1');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('30','30', 'IMPERATRIZ', 'IMPERATRIZ');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('31','31', 'ITACOATIARA', 'ITACOATIARA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('32','32', 'MACAP\u00c1', 'MACAP\u00c1');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('33','33', 'MANAUS-CENTRO', 'MANAUS-CENTRO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('34','34', 'MARAB\u00c1' , 'MARAB\u00c1');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('37','37', 'NATIVIDADE', 'NATIVIDADE');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('40','40', 'PEDRO AFONSO', 'PEDRO AFONSO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('42','42', 'PORTO NACIONAL', 'PORTO NACIONAL');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('43','43', 'PORTO VELHO', 'PORTO VELHO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('47','47', 'S\u00c3O LUIZ - CENTRO' , 'S\u00c3O LUIZ - CENTRO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('48','48', 'S\u00c3O PAULO', 'S\u00c3O PAULO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('50','50', 'SOURE', 'SOURE');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('53','53', 'TOCANTIN\u00d3POLIS', 'TOCANTIN\u00d3POLIS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('56','56', 'HUMAIT\u00c1', 'HUMAIT\u00c1');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('59','59', 'GURUPI', 'GURUPI');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('61','61', 'SANTA IN\u00caS', 'SANTA IN\u00caS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('67','67', 'BARRA DO GAR\u00c7AS', 'BARRA DO GAR\u00c7AS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('69','69', 'PINHEIRO', 'PINHEIRO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('73','73', 'JI-PARAN\u00c1', 'JI-PARAN\u00c1');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('75','75', 'RUR\u00d3POLIS', 'RUR\u00d3POLIS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('163','163', 'SINOP', 'SINOP');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('4','4', 'ALTAMIRA', 'ALTAMIRA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('5','5', 'BACABAL', 'BACABAL');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('134','134', 'BURITIS', 'BURITIS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('15','15', 'CAMET\u00c1', 'CAMET\u00c1');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('16','16', 'CAPANEMA', 'CAPANEMA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('35','35', 'MAU\u00c9S', 'MAU\u00c9S');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('36','36', 'MONTE ALEGRE', 'MONTE ALEGRE');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('39','39', 'PARINTINS', 'PARINTINS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('44','44', 'RIO BRANCO', 'RIO BRANCO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('46','46', 'SANTAR\u00c9M', 'SANTAR\u00c9M');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('49','49', 'SENA MADUREIRA', 'SENA MADUREIRA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('51','51', 'TARAUACA', 'TARAUACA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('55','55', 'CAXIAS', 'CAXIAS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('58','58', 'DIAN\u00d3POLIS', 'DIAN\u00d3POLIS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('60','60', 'MIRAC. DO TOCANTINS', 'MIRAC. DO TOCANTINS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('64','64', 'PARAGOMINAS', 'PARAGOMINAS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('68','68', 'CAROLINA', 'CAROLINA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('70','70', 'BELPEDREIRA', 'BELPEDREIRA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('76','76', 'CONC. DO ARAGUAIA', 'CONC. DO ARAGUAIA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('93','93', 'GUARA\u00cd', 'GUARA\u00cd');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('99','99', 'CACOAL', 'CACOAL');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('100','100', 'ARIQUEMES', 'ARIQUEMES');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('105','105', 'TUCURU\u00cd', 'TUCURU\u00cd');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('115','115', 'CARAUARI', 'CARAUARI');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('117','117', 'CARAJ\u00c1S', 'CARAJ\u00c1S');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('118','118', 'SFDO XINGU', 'SFDO XINGU');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('119','119', 'OBIDOS', 'OBIDOS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('126','126', 'ARAGUAINA', 'ARAGUAINA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('127','127', 'PALMAS', 'PALMAS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('17','17', 'CASTANHAL', 'CASTANHAL');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('179','179', 'ELDORADO DOS CARAJAS', 'ELDORADO DOS CARAJAS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('133','133', 'NOVO PROGRESSO', 'NOVO PROGRESSO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('147','147', 'NOVO REPARTIMENTO', 'NOVO REPARTIMENTO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('183','183', 'GIRASSOIS - PALMAS', 'GIRASSOIS - PALMAS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('182','182', 'MANAUS-CACHOEIRINHA', 'MANAUS-CACHOEIRINHA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('187','187', 'JACUND\u00c1', 'JACUND\u00c1');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('188','188', 'JARU', 'JARU');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('191','191', 'PINHEIRO MACHADO - PORTO VELHO', 'PINHEIRO MACHADO - PORTO VELHO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('181','181', 'LARANJAL DO JARI', 'LARANJAL DO JARI');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('27','27', 'GUAJARMIRIM', 'GUAJARMIRIM');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('28','28', 'GUIRATINGA', 'GUIRATINGA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('122','122', 'RONDON\u00d3POLIS', 'RONDON\u00d3POLIS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('25','25', 'FEIJ\u00d3', 'FEIJ\u00d3');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('162','162', 'SANTANA', 'SANTANA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('84','84', 'SHOPPING SUMA- MANAUS', 'SHOPPING SUMA- MANAUS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('114','114', 'ITAITUBA', 'ITAITUBA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('159','159', 'LUCAS DO RIO VERDE', 'LUCAS DO RIO VERDE');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('128','128', 'BELREDUTO', 'BELREDUTO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('160','160', 'PAB - NOVA IPIXUNA', 'PAB - NOVA IPIXUNA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('108','108', 'BRAGAN\u00c7A', 'BRAGAN\u00c7A');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('2','2', 'ABAETETUBA', 'ABAETETUBA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('124','124', 'ANANINDEUA C.NOVA', 'ANANINDEUA C.NOVA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('171','171', 'Xambio\u00e1', 'Xambio\u00e1');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('194','194', 'PL\u00c1CIDO DE CASTRO', 'PL\u00c1CIDO DE CASTRO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('164','164', 'TAIL\u00c2NDIA', 'TAIL\u00c2NDIA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('168','168', 'RONDON DO PARA', 'RONDON DO PARA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('165','165', 'TUCUMA', 'TUCUMA');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('167','167', 'ARAGUATINS', 'ARAGUATINS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('173','173', 'PAA PLACAS', 'PAA PLACAS');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('170','170', 'VITORIA DO MEARIM', 'VITORIA DO MEARIM');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('7','7', 'BELCENTRO', 'BELCENTRO');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('169','169', 'CANA\u00c3 DOS CARAJ\u00c1S', 'CANA\u00c3 DOS CARAJ\u00c1S');\nINSERT IGNORE INTO AGENCIA(ID, COD_AG, NOME, DESCRICAO) VALUES ('195','195', 'CEREJEIRAS', 'CEREJEIRAS');");
        System.out.println(pst);
        int rs = pst.executeUpdate();
        System.out.println(String.valueOf(rs));
    }
}

